![[Pasted image 20250413194920.png]]

![[Pasted image 20250413194934.png]]
RAT is not needed for Private Listeners since it is from internal hosts to outbound. 

#### Overview
- The RAT is used by the Cisco Secure Email Gateway to determine which recipient addresses are allowed to receive emails from external senders.
- The RAT is **used exclusively by public listeners**.
- Defines whether to accept or reject emails based on recipient parameters.
### RAT Configuration
#### Parameters for Recipient Definition
- Domain name
- Partial domain
- Username
- Full email address or group of email addresses
#### Default Setup
- The System Setup Wizard guides the configuration of at least one public listener, which includes specifying default local domains or specific addresses.
- Default entry "All Other Recipients" rejects emails from all non-specified recipients.
- Local domains and specific users can be defined to accept or reject messages.

### Email Processing with RAT
#### Matching Process
- Emails accepted by the HAT are forwarded to the RAT for recipient verification.
- The RAT checks recipients in a top-down order, emphasizing the importance of configuration order to avoid unexpected results.
#### Bypass Features
- **LDAP Acceptance Bypass**: Allows certain recipients to skip LDAP queries to prevent delays (e.g., [support@example.com](mailto:support@example.com)).
- **Bypass Receiving Control**: Permits unlimited messages for specific recipients despite throttling controls.

### Example Configuration
![[Pasted image 20250413195135.png]]
#### Scenario
- Two custom-defined recipients and a default reject-all entry.
- Email to exchange.juliet.com domai is accepted; email to notes.juliet.com domain is rejected except for [bob@notes.juliet.com](mailto:bob@notes.juliet.com).
- Adding notes.juliet.com to the RAT allows emails to be accepted for all recipients in that domain.

### Using LDAP for Recipient Checking
#### LDAP Integration
- LDAP queries can validate recipient email addresses against directory information.
- Supports LDAP and LDAP over SSL/TLS.
- Queries ensure emails are only accepted for existing users in the directory.
#### Example
- Emails are accepted by RAT and validated against LDAP.
- Emails to non-existent addresses in LDAP are rejected to conserve resources.

### Use Case: Integration with LDAP
#### Purpose
- Prevents acceptance of emails for non-existent addresses, reducing resource waste.
- Queries LDAP for recipient validation after RAT acceptance.

#### Example Flow
1. **Email to [sam@example.com](mailto:sam@example.com)**: Rejected by RAT.
2. **Email to [john@exchange.juliet.com](mailto:john@exchange.juliet.com)**: Accepted by RAT, rejected by LDAP.
3. **Email to [juliet@exchange.juliet.com](mailto:juliet@exchange.juliet.com)**: Accepted by both RAT and LDAP, delivered successfully.
### Summary
- Proper configuration of the RAT is crucial for email acceptance and routing.
- Integrating LDAP enhances security and ensures only legitimate email addresses receive messages.
- By configuring recipient entries and bypass options effectively, organizations can tailor email acceptance to their specific needs.